/*
 *  xmem.c - Memory Management routines with error checking
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include "xmem.h"

/* Like malloc only with error checking */
void* xmalloc(size_t size) {
  void* ptr;
  if ((ptr = malloc(size)) == NULL) {
    fprintf(stderr, "Unable to allocate %d bytes of memory\n", (int)size);
    exit(1);
  }
  else
    return ptr;
}

/* Like realloc only with error checking */
void* xrealloc(void* ptr, size_t size) {
  if ((ptr = realloc(ptr, size)) == NULL) {
    fprintf(stderr, "Unable to reallocate memory\n");
    exit(1);    
  }
  else
    return ptr;
}

/* Like free only with error checking */
void xfree(void* ptr) {
  free(ptr);
}
