#include <stdio.h>
#include "symtab.h"
#include "xmem.h"
#include "data.h"

#define INITIAL_SIZE  255
#define GROWTH_SIZE   255
/* max size should be a settable parameter! */
#define MAX_SIZE     4096

char foo[2048];

/* Internal helper functions */
int init_symtab(void);
int grow_symtab(void);

int initialized = 0;  /* not initialized */
long current_size = 0; /* size of symbol table */
long entries = 0;      /* number of entries in the symbol table */

int init_symtab(void) {
  int i;
  //fprintf(stderr, ">>> initializing symbol table\n");
  symtab = (char**)xmalloc(INITIAL_SIZE*sizeof(char*));
  current_size = INITIAL_SIZE;
  for (i = 0; i < current_size; i++)
    symtab[i] = NULL;
  initialized = 1;
  return 0;
}

int grow_symtab(void) {
  //fprintf(stderr, ">>> reallocating symbol table\n");
  current_size += GROWTH_SIZE;
  symtab = (char**)xrealloc(symtab, current_size*sizeof(char*));
  return 0;
}

char* lookup_symtab(char* s) {
  char* iter;
  int i = 0;

  //sprintf(foo, ">>> Looking for '%s'\n", s);
  //fprintf(stderr, foo);

  /* Initialize the memory structure if not already done */
  if (!initialized) {
    init_symtab();
  }

  /* lookup and add if not present */
  //for (i=0; i<current_size;i++) {
  i = 0;
  while (i<current_size) {
    iter = symtab[i];

    /* Already added? */
    if (iter && strcmp(iter, s) == 0) {
      //sprintf(foo, ">>> string already present (%d)\n", i);
      fprintf(stderr, foo);
      return iter;
    }

    /* Is it free? */
    if (!iter) {
      //sprintf(foo, ">>> adding string (%d)\n", i);
      fprintf(stderr, foo);
      entries++;
      symtab[i] = (char*)strdup(s);
      return symtab[i];
    }

    /* out of memory? */
    if (i == current_size-1) {
      //fprintf(stderr, ">>> Uh-oh, out of memory\n");
      grow_symtab();
    }

    i++;
  }

  return NULL;
}

void print_mem(void) {
  int i;
  long bytes = 0;
  float kbytes;

  fprintf(stderr, "======== Memory usage =======\n");
  sprintf(foo, "Records used: %d\n", entries);
  fprintf(stderr, foo);
  sprintf(foo, "Records initialized: %d\n", current_size);
  fprintf(stderr, foo);

  /* count */
  for (i=0; i<entries-1;i++) {
    bytes += strlen(symtab[i]);
  }

  /* add pointer size */
  bytes += (current_size * sizeof(char*));

  if (bytes < 1024)
    sprintf(foo, "Memory used: %d b\n", bytes);
  else {
    kbytes = (float)(bytes / 1024.0);
    sprintf(foo, "Memory used: %0.2f kb\n", kbytes);    
  }
  fprintf(stderr, foo);
  fprintf(stderr, "==============================\n");
}
