/* -*- Mode: C; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Copyright 1999 David Williams. All rights reserved.
 *
 * tobuf.c
 *
 * created: djw@djw.org, January 2, 1999.
 */
#include "prcp.h"

void
prcuint16tobuf(void* vbuf, prc_uint16_t i)
{
    prc_byte_t* buf = (prc_byte_t*)vbuf;

    buf[0] = (i >> 8) & 0xff;
    buf[1] = (i) & 0xff;
}

void
prcuint32tobuf(void* vbuf, prc_uint32_t i)
{
    prc_byte_t* buf = (prc_byte_t*)vbuf;

    buf[0] = (prc_byte_t)((i >> 24) & 0xff);
    buf[1] = (prc_byte_t)((i >> 16) & 0xff);
    buf[2] = (prc_byte_t)((i >> 8) & 0xff);
    buf[3] = (prc_byte_t)((i) & 0xff);
}

void
prcuint24tobuf(void* vbuf, prc_uint32_t i)
{
    prc_byte_t* buf = (prc_byte_t*)vbuf;

    buf[0] = (prc_byte_t)((i >> 16) & 0xff);
    buf[1] = (prc_byte_t)((i >> 8) & 0xff);
    buf[2] = (prc_byte_t)((i) & 0xff);
}
