/* -*- Mode: C; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Copyright 1999 David Williams. All rights reserved.
 *
 * time.c
 *
 * created: djw@djw.org, January 2, 1999.
 */
#include <time.h>

#include "prcp.h"

prc_time_t
prctime(prc_time_t* buf)
{
    time_t     utime;
    prc_time_t ptime;

    if (time(&utime) == (time_t)-1)
        return (prc_time_t)-1;

    ptime = UNIX_TO_MAC_TIME(utime);
    if (buf != NULL)
        *buf = ptime;

    return ptime;
}
