/* -*- Mode: C; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Copyright 1999 David Williams. All rights reserved.
 *
 * recrem.c
 *
 * created: djw@djw.org, May 15, 1999.
 */
#include <stdlib.h>
#include <memory.h>

#include "prcp.h"

prc_record_t*
prcremoverecord(prc_t* prc, prc_record_t* rec)
{
    prc_internal_t* iprc = PRC_PRCTOINTERNAL(prc);
    prc_internal_record_t* prev;
    prc_internal_record_t* foo;
    
    prev = NULL;
    for (foo = iprc->records; foo != NULL; prev = foo, foo = foo->next) {
        if (foo == (prc_internal_record_t*)rec)
            break;
    }

    if (foo != NULL) {
    
        if (prev != NULL) {
            prev->next = foo->next;
        } else {
            iprc->records = foo->next;
        }

        foo->next = 0;

        iprc->header.nrecords--;
        
        return rec;
    }
    
    return 0;
}
