/* -*- Mode: C; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Copyright 1999 David Williams. All rights reserved.
 *
 * recmap.c
 *
 * created: djw@djw.org, January 2, 1999.
 */
#include "prcp.h"

int
prcmaprecords(prc_t* prc, prc_record_mappee_t func, void* arg)
{
    prc_internal_t* iprc = PRC_PRCTOINTERNAL(prc);
    prc_internal_record_t* irecord;
    int rv = 0;

    for (irecord = iprc->records; irecord != NULL; irecord = irecord->next) {
	rv = func((prc_record_t*)irecord, arg);

	if (rv != 0)
	    break;
    }

    return rv;
}

