/* -*- Mode: C; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Copyright 1999 David Williams. All rights reserved.
 *
 * fwrsrc.c
 *
 * created: djw@djw.org, January 2, 1999.
 */
#include <stdio.h>

#include "prcp.h"

int
prcfwriteresource(FILE* fp, prc_resource_header_t* resource)
{
    prc_file_resource_header_t fbuf;

    prcuint32tobuf(&fbuf.offset, resource->offset);
    prcuint32tobuf(&fbuf.type, resource->type);
    prcuint16tobuf(&fbuf.id, resource->id);

    if (fwrite(&fbuf, sizeof(prc_file_resource_header_t), 1, fp) != 1)
        return -1;

    return 0;
}
