/* -*- Mode: C; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Copyright 1999 David Williams. All rights reserved.
 *
 * frhead.c
 *
 * created: djw@djw.org, January 2, 1999.
 */
#include <stdlib.h>
#include <memory.h>
#include <string.h>

#include "prcp.h"

int
prcfreadheader(FILE* fp,
               prc_t* prc,
               prc_uint32_t* appInfoOffset_r,
               prc_uint32_t* sortInfoOffset_r)
{
    prc_file_t fbuf;
    prc_uint32_t appInfoOffset;
    prc_uint32_t sortInfoOffset;

    if (fread(&fbuf, sizeof(prc_file_t), 1, fp) != 1)
        return -1;

    memset(prc, 0, sizeof(prc_t));
    strncpy(&prc->name[0], fbuf.name, 32);

    prc->flags = prcbuftouint16(&fbuf.flags);
    prc->version = prcbuftouint16(&fbuf.version);
    prc->ctime = prcbuftouint32(&fbuf.ctime);
    prc->mtime = prcbuftouint32(&fbuf.mtime);
    prc->btime = prcbuftouint32(&fbuf.btime);
    prc->modnum = prcbuftouint32(&fbuf.modnum);
    appInfoOffset = prcbuftouint32(&fbuf.appinfo);
    sortInfoOffset = prcbuftouint32(&fbuf.sortinfo);
    prc->type = prcbuftouint32(&fbuf.type);
    prc->cid = prcbuftouint32(&fbuf.cid);
    /* seedID */
    /* nextRecord */
    prc->nrecords = prcbuftouint16(&fbuf.nrecords);

    /* if sortInfo != 0, use it to determine appInfo size */
    *appInfoOffset_r = appInfoOffset;
    *sortInfoOffset_r = sortInfoOffset;

    return 0;
}
