/* -*- Mode: C; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Copyright 1999 David Williams. All rights reserved.
 *
 * bufto.c
 *
 * created: djw@djw.org, January 2, 1999.
 */
#include "prcp.h"

prc_uint16_t
prcbuftouint16(const void* vbuf)
{
    prc_byte_t*  buf = (prc_byte_t*)vbuf;
    prc_uint16_t rv;

    rv = 
	((prc_uint16_t)buf[0] << 8) +
	((prc_uint16_t)buf[1] << 0);

    return rv;
}

prc_uint32_t
prcbuftouint32(const void* vbuf)
{
    prc_byte_t*  buf = (prc_byte_t*)vbuf;
    prc_uint32_t rv;

    rv = 
	((prc_uint32_t)buf[0] << 24) +
	((prc_uint32_t)buf[1] << 16) +
	((prc_uint32_t)buf[2] << 8) +
	((prc_uint32_t)buf[3] << 0);

    return rv;
}

prc_uint32_t
prcbuftouint24(const void* vbuf)
{
    prc_byte_t*  buf = (prc_byte_t*)vbuf;
    prc_uint32_t rv;

    rv = 
	((prc_uint32_t)buf[0] << 16) +
	((prc_uint32_t)buf[1] << 8) +
	((prc_uint32_t)buf[2] << 0);

    return rv;
}
