/* JMC - JuggleMaster Pattern Converter
 *
 * Version 1.0
 * Copyright (C) Per Johan Persson 2001
 *
 *
 * jmc.c - Main wrapper file
 *
 */

#include <stdlib.h>
#include <stdio.h>
/*#include "y.tab.h"*/
#include "symtab.h"
#include "data.h"
#include "jmc_error.h"

void setfile(FILE* file);
void parse(void);

extern int lineno;

int main(int argc, char* argv[]) {
  //char foz[] = "qwertyuiop";
  //char fox[] = "asdfghjkl1234";

  /* Open file if given */
  if (argc > 1) {
    FILE* file = fopen(argv[1], "r");

    if (!file) {
      fprintf(stderr, "Unable to open %s\n", argv[1]);
      exit(1);
    }

    setfile(file);
  }
  else {
    fprintf(stderr, "Usage: jmc <patternfile> <outputfile>\n");
    fprintf(stderr, "output file can be omitted, in which case jmpalmdb.pdb "
            "will be used.\n");
    return 1;
  }

  fprintf(stderr, "JMC - JuggleMaster pattern converter v1.0\n");
  fprintf(stderr, "Copyright (C) Per Johan Persson 2001\n");

  /* Initialize data structures */
  init_data();

  parse();

  fprintf(stderr, "Done parsing\n");

  //print_mem();
  //print_styledata();
  //print_styledef();
  //print_pattdef();
  //print_cat();
  //print_hdr();

  err_report();

  if (!ok_to_continue()) {
    fprintf(stderr, "Errors found, output file not written\n");
    exit(1);
  }

  finalize_data();

  if (argc < 3)
    open_database("jmpalmdb.pdb");
  else
    open_database(argv[2]);

  write_database();

  close_database();

  return 0;
}
